/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.renderers.tree;

import com.ibm.hwmca.fw.servlet.renderers.tree.CustomTreeNode;
import com.ibm.psw.wcl.components.tree.IFDAHyperlinkTreeNode;
import com.ibm.psw.wcl.components.tree.TreeCellInfo;
import com.ibm.psw.wcl.components.tree.WTree;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.cell.DefaultHyperlinkCell;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.core.skin.StyleDescriptor;
import com.ibm.psw.wcl.renderers.tree.html.HTMLTreeCellRenderer;
import com.ibm.psw.wcl.skins.base.BaseHyperlinkStyleInfo;
import java.util.Collection;
import java.util.Properties;
import javax.swing.tree.TreePath;

public class CustomHTMLTreeCellRenderer
extends HTMLTreeCellRenderer {
    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo cellInfo) throws RendererException {
        Object val;
        if (cell == null || cellInfo == null) {
            throw new RendererException("Null parameter passed to tree cell renderer.");
        }
        TreeCellInfo modelEtc = (TreeCellInfo)cellInfo;
        if (cell instanceof DefaultHyperlinkCell) {
            cell = this.prepareCell(rc, (DefaultHyperlinkCell)cell, modelEtc);
        }
        if ((val = modelEtc.getValue()) instanceof CustomTreeNode && ((CustomTreeNode)val).isEnabled() || !(val instanceof CustomTreeNode)) {
            WTree tree = (WTree)modelEtc.getOwnerComponent();
            TreePath path = modelEtc.getPath();
            String action = null;
            if (tree != null && path != null && cell instanceof DefaultHyperlinkCell) {
                Properties parms = new Properties();
                int index = tree.getIndexForPath(path);
                if (index == -1) {
                    throw new RendererException("Bad internal tree path index.");
                }
                if (tree.isFeatureEnabled(2)) {
                    action = "treeSel";
                    if (tree.getModel().getSelectionMode() != 1) {
                        modelEtc.setSelected(false);
                    }
                } else {
                    action = "treeAct";
                }
                String wclHiddenAction = tree.getID() + "_" + action;
                action = action + "(" + index + ")";
                parms.setProperty("treeFunc", action);
                WHyperlink aLinkComp = ((DefaultHyperlinkCell)cell).getHyperlink();
                aLinkComp.setTriggerParameters(parms);
                String anchorId = wclHiddenAction + "(" + index + ")";
                aLinkComp.setName(anchorId);
                aLinkComp.setID(anchorId);
                this.generateOnClickScript(rc, (DefaultHyperlinkCell)cell, modelEtc, wclHiddenAction, action, anchorId, tree.isAnchoring());
                Object nodeValue = cellInfo.getValue();
                if (nodeValue instanceof IFDAHyperlinkTreeNode) {
                    String fdaText;
                    IFDAHyperlinkTreeNode fdaActionNode = (IFDAHyperlinkTreeNode)nodeValue;
                    String fdaTitle = fdaActionNode.getFDATitle();
                    if (fdaTitle != null) {
                        aLinkComp.setFDATitle(fdaTitle);
                    }
                    if ((fdaText = fdaActionNode.getFDAText()) != null) {
                        aLinkComp.setFDAText(fdaText);
                    }
                }
                cell.addAllFDAContent((Collection)aLinkComp.getFDAContentCallback().getFDAContents(rc));
                IOutput cellOutput = cell.getOutput(rc);
                aLinkComp.setName(wclHiddenAction);
                aLinkComp.setID(wclHiddenAction);
                return cellOutput;
            }
        } else if (cell instanceof DefaultHyperlinkCell) {
            WHyperlink aLinkComp = ((DefaultHyperlinkCell)cell).getHyperlink();
            aLinkComp.setEnabled(false);
            BaseHyperlinkStyleInfo cellStyle = new BaseHyperlinkStyleInfo();
            StyleDescriptor sd = cellStyle.getStyleDescriptor("lnk1");
            sd.setStyleValue("font-style", (Object)"italic");
            sd.setStyleValue("color", (Object)"#AAAAAA");
            aLinkComp.setStyleInfo((AStyleInfo)cellStyle);
            IOutput cellOutput = cell.getOutput(rc);
            aLinkComp.setEnabled(true);
            aLinkComp.setStyleInfo(null);
            return cellOutput;
        }
        return cell.getOutput(rc);
    }
}

